
<?php
require '../config/db.php';
$total = 0;
$productos = [];

if (!empty($_POST['productos'])) {
    $ids = implode(',', array_fill(0, count($_POST['productos']), '?'));
    $stmt = $pdo->prepare("SELECT * FROM productos WHERE id IN ($ids)");
    $stmt->execute($_POST['productos']);
    $productos = $stmt->fetchAll(PDO::FETCH_ASSOC);

    foreach ($productos as $p) {
        $total += $p['precio'];
    }
}
?>
<!doctype html>
<html lang="es">
<head>
  <meta charset="utf-8">
  <title>Cotización Final</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="container mt-5">
  <h2 class="mb-4">Resumen de Cotización</h2>
  <table class="table table-striped">
    <thead>
      <tr><th>Nombre</th><th>Precio</th></tr>
    </thead>
    <tbody>
      <?php foreach ($productos as $p): ?>
        <tr>
          <td><?= $p['nombre'] ?></td>
          <td>$<?= number_format($p['precio'], 2) ?></td>
        </tr>
      <?php endforeach; ?>
    </tbody>
  </table>
  <h4 class="mt-3">Total: <strong>$<?= number_format($total, 2) ?></strong></h4>
  <a class="btn btn-secondary mt-3" href="index.php">Volver</a>
</body>
</html>
