
<?php
require '../config/db.php';

$categorias = $pdo->query("
    SELECT id, nombre FROM categorias
    WHERE habilitada = 1
    ORDER BY nombre
")->fetchAll(PDO::FETCH_ASSOC);
?>
<!doctype html>
<html lang="es">
<head>
  <meta charset="utf-8">
  <title>Cotizador con Carrito</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <script>
    let productos = {};
    let carrito = [];

    async function cargarProductos(categoriaId) {
      const response = await fetch("productos_por_categoria.php?categoria_id=" + categoriaId);
      const data = await response.json();
      productos = data;
      mostrarProductos();
    }

    function mostrarProductos() {
      const tbody = document.getElementById("productos-body");
      tbody.innerHTML = "";
      productos.forEach(prod => {
        const tr = document.createElement("tr");
        tr.innerHTML = `
          <td>${prod.codigo}</td>
          <td>${prod.nombre}</td>
          <td>$${parseFloat(prod.precio).toFixed(2)}</td>
          <td><button class='btn btn-sm btn-primary' onclick='agregarAlResumen(${JSON.stringify(prod)})'>Agregar</button></td>
        `;
        tbody.appendChild(tr);
      });
    }

    function agregarAlResumen(prod) {
      carrito.push(prod);
      actualizarResumen();
    }

    function eliminarDelResumen(index) {
      carrito.splice(index, 1);
      actualizarResumen();
    }

    function actualizarResumen() {
      const resumen = document.getElementById("resumen-body");
      resumen.innerHTML = "";
      let total = 0;
      carrito.forEach((item, i) => {
        total += parseFloat(item.precio);
        const row = document.createElement("tr");
        row.innerHTML = `
          <td>${item.codigo}</td>
          <td>${item.nombre}</td>
          <td>$${parseFloat(item.precio).toFixed(2)}</td>
          <td><button class='btn btn-sm btn-danger' onclick='eliminarDelResumen(${i})'>Eliminar</button></td>
        `;
        resumen.appendChild(row);
      });
      document.getElementById("total").innerText = total.toFixed(2);
    }
  </script>
</head>
<body class="container mt-5">
  <h2 class="mb-4">Cotizador de Productos</h2>

  <div class="mb-3">
    <label for="categoria" class="form-label">Seleccionar Categoría:</label>
    <select id="categoria" class="form-select" onchange="cargarProductos(this.value)">
      <option value="">-- Selecciona --</option>
      <?php foreach ($categorias as $cat): ?>
        <option value="<?= $cat['id'] ?>"><?= htmlspecialchars($cat['nombre']) ?></option>
      <?php endforeach; ?>
    </select>
  </div>

  <h4>Productos</h4>
  <table class="table table-bordered">
    <thead class="table-light">
      <tr><th>Código</th><th>Nombre</th><th>Precio</th><th>Acción</th></tr>
    </thead>
    <tbody id="productos-body"></tbody>
  </table>

  <h4 class="mt-5">Resumen de Cotización</h4>
  <table class="table table-striped">
    <thead><tr><th>Código</th><th>Nombre</th><th>Precio</th><th>Eliminar</th></tr></thead>
    <tbody id="resumen-body"></tbody>
  </table>
  <h5>Total: $<span id="total">0.00</span></h5>
</body>
</html>
