
<?php
require '../config/db.php';
require '../vendor/autoload.php';

use PhpOffice\PhpSpreadsheet\IOFactory;

if ($_FILES['archivo']['error'] === UPLOAD_ERR_OK) {
    $archivoTmp = $_FILES['archivo']['tmp_name'];
    $spreadsheet = IOFactory::load($archivoTmp);
    $hoja = $spreadsheet->getActiveSheet();
    $filas = $hoja->toArray();

    $pdo->beginTransaction();
    try {
        foreach ($filas as $i => $fila) {
            if ($i === 0) continue;
            list($codigo, $nombre, $precio, $categoriaNombre) = $fila;

            $stmt = $pdo->prepare("SELECT id FROM categorias WHERE nombre = ? AND habilitada = 1");
            $stmt->execute([$categoriaNombre]);
            $categoria = $stmt->fetch(PDO::FETCH_ASSOC);
            if (!$categoria) {
                throw new Exception("Categoría '{$categoriaNombre}' no encontrada en la fila " . ($i + 1));
            }

            $stmt = $pdo->prepare("INSERT INTO productos (codigo, nombre, precio, categoria_id) VALUES (?, ?, ?, ?)");
            $stmt->execute([$codigo, $nombre, $precio, $categoria['id']]);
        }
        $pdo->commit();
        echo "<div class='alert alert-success m-5'>Productos importados correctamente.</div>";
    } catch (Exception $e) {
        $pdo->rollBack();
        echo "<div class='alert alert-danger m-5'>Error: " . $e->getMessage() . "</div>";
    }
} else {
    echo "<div class='alert alert-danger m-5'>Error al subir el archivo.</div>";
}
echo '<a class="btn btn-secondary m-5" href="index.php">Volver</a>';
?>
