
<?php
require '../config/db.php';
$stmt = $pdo->query("SELECT * FROM productos");
$productos = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>
<!doctype html>
<html lang="es">
<head>
  <meta charset="utf-8">
  <title>Administrador</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="container mt-5">
  <h2 class="mb-4">Lista de Productos</h2>
  
  <div class="row">
    <div class="col-md-6">
    <a class="btn btn-success mb-3" href="add_product.php">Agregar producto</a>
    </div>
    <div class="col-md-6">
    <a class="btn btn-success mb-3" href="nueva_categoria.php">Agregar categorias</a>
    </div>
  </div>
  <table class="table table-bordered table-striped">
    <thead class="table-dark">
      <tr><th>ID</th><th>Codigo</th><th>Nombre</th><th>Precio</th></tr>
    </thead>
    <tbody>
      <?php foreach ($productos as $p): ?>
        <tr>
          <td><?= $p['id'] ?></td>
          <td><?= $p['codigo'] ?></td>
          <td><?= $p['nombre'] ?></td>
          <td>$<?= number_format($p['precio'], 2) ?></td>
        </tr>
      <?php endforeach; ?>
    </tbody>
  </table>
</body>
</html>
