
<?php
require '../config/db.php';

if (isset($_GET['accion']) && isset($_GET['id'])) {
    $accion = $_GET['accion'];
    $id = $_GET['id'];
    $estado = ($accion === 'deshabilitar') ? 0 : 1;
    $stmt = $pdo->prepare("UPDATE categorias SET habilitada = ? WHERE id = ?");
    $stmt->execute([$estado, $id]);
    header("Location: categorias.php");
    exit;
}

$stmt = $pdo->query("SELECT * FROM categorias");
$categorias = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>
<!doctype html>
<html lang="es">
<head>
  <meta charset="utf-8">
  <title>Categorías</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="container mt-5">
  <h2 class="mb-4">Administrar Categorías</h2>
  <a class="btn btn-success mb-3" href="nueva_categoria.php">Agregar Categoría</a>
  <table class="table table-bordered">
    <thead class="table-dark">
      <tr><th>ID</th><th>Nombre</th><th>Estado</th><th>Acciones</th></tr>
    </thead>
    <tbody>
      <?php foreach ($categorias as $c): ?>
        <tr>
          <td><?= $c['id'] ?></td>
          <td><?= $c['nombre'] ?></td>
          <td><?= $c['habilitada'] ? 'Habilitada' : 'Deshabilitada' ?></td>
          <td>
            <?php if ($c['habilitada']): ?>
              <a href="?accion=deshabilitar&id=<?= $c['id'] ?>" class="btn btn-warning btn-sm">Deshabilitar</a>
            <?php else: ?>
              <a href="?accion=habilitar&id=<?= $c['id'] ?>" class="btn btn-success btn-sm">Habilitar</a>
            <?php endif; ?>
          </td>
        </tr>
      <?php endforeach; ?>
    </tbody>
  </table>
</body>
</html>
