
<?php
require '../config/db.php';

$categorias = $pdo->query("SELECT * FROM categorias WHERE habilitada = 1")->fetchAll(PDO::FETCH_ASSOC);

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $codigo = $_POST['codigo'];
    $nombre = $_POST['nombre'];
    $precio = $_POST['precio'];
    $categoria_id = $_POST['categoria_id'];
    $stmt = $pdo->prepare("INSERT INTO productos (codigo, nombre, precio, categoria_id) VALUES (?, ?, ?, ?)");
    $stmt->execute([$codigo, $nombre, $precio, $categoria_id]);
    header("Location: index.php");
}
?>
<!doctype html>
<html lang="es">
<head>
  <meta charset="utf-8">
  <title>Agregar Producto</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="container mt-5">
  <h2 class="mb-4">Agregar Producto</h2>
  <form method="POST" class="card p-4 shadow-sm">
    <div class="mb-3">
      <label class="form-label">Código:</label>
      <input type="text" class="form-control" name="codigo" required>
    </div>
    <div class="mb-3">
      <label class="form-label">Nombre:</label>
      <input type="text" class="form-control" name="nombre" required>
    </div>
    <div class="mb-3">
      <label class="form-label">Precio:</label>
      <input type="number" class="form-control" step="0.01" name="precio" required>
    </div>
    <div class="mb-3">
      <label class="form-label">Categoría:</label>
      <select class="form-select" name="categoria_id" required>
        <option value="">Seleccionar categoría</option>
        <?php foreach ($categorias as $cat): ?>
          <option value="<?= $cat['id'] ?>"><?= $cat['nombre'] ?></option>
        <?php endforeach; ?>
      </select>
    </div>
    <button type="submit" class="btn btn-primary">Guardar</button>
    <a href="index.php" class="btn btn-secondary">Volver</a>
  </form>
</body>
</html>
